/*
 * sstar_rpmsg.c- Sigmastar
 *
 * Copyright (c) [2019~2020] SigmaStar Technology.
 *
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License version 2 for more details.
 *
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/virtio.h>
#include <linux/rpmsg.h>

#define MSG		"hello world!"
#define MSG_LIMIT	100000
static unsigned int rpmsg_pingpong;
static int rx_count;

struct rpmsg_pingpong_dev
{
	unsigned int rpmsg_pingpong1;
	int rx_count1;
	struct rpmsg_endpoint *ept1;

	unsigned int rpmsg_pingpong2;
	int rx_count2;
	struct rpmsg_endpoint *ept2;
};

static int rpmsg_pingpong_cb(struct rpmsg_device *rpdev, void *data, int len,
						void *priv, u32 src)
{
	int err;

	/* reply */
	rpmsg_pingpong = *(unsigned int *)data;
	printk("get %d (src: 0x%x)\n",
			rpmsg_pingpong, src);
	rx_count++;

	/* pingpongs should not live forever */
	if (rx_count >= MSG_LIMIT) {
		dev_info(&rpdev->dev, "goodbye!\n");
		return 0;
	}
	rpmsg_pingpong++;
	err = rpmsg_sendto(rpdev->ept, (void *)(&rpmsg_pingpong), 4, src);

	printk("send %u (dst: 0x%x)\n",
		rpmsg_pingpong, src);
	if (err)
		dev_err(&rpdev->dev, "rpmsg_send failed: %d\n", err);

	return err;
}

static int rpmsg_pingpong_test_cb(struct rpmsg_device *rpdev, void *data, int len,
				void *priv, u32 src)
{
	int err;
	struct rpmsg_pingpong_dev *pingpong_dev = (struct rpmsg_pingpong_dev *)priv;
	/* reply */
	rpmsg_pingpong = *(unsigned int *)data;
	printk("get %d (src: 0x%x)\n",
			rpmsg_pingpong, src);
	rx_count++;

	/* pingpongs should not live forever */
	if (rx_count >= MSG_LIMIT) {
		dev_info(&rpdev->dev, "goodbye!\n");
		return 0;
	}
	rpmsg_pingpong++;
	err = rpmsg_sendto(pingpong_dev->ept1, (void *)(&rpmsg_pingpong), 4, src);

	printk("send %u (dst: 0x%x)\n",
		rpmsg_pingpong, src);
	if (err)
		dev_err(&rpdev->dev, "rpmsg_send failed: %d\n", err);

	return err;
}

static int rpmsg_pingpong_probe(struct rpmsg_device *rpdev)
{
	int err;
	struct rpmsg_pingpong_dev *pingpong_dev;
	struct rpmsg_channel_info chinfo = {};

	dev_info(&rpdev->dev, "new channel: 0x%x -> 0x%x!\n",
			rpdev->src, rpdev->dst);

	pingpong_dev = (struct rpmsg_pingpong_dev *)kzalloc(sizeof(struct rpmsg_pingpong_dev), GFP_KERNEL);
	dev_set_drvdata(&rpdev->dev, pingpong_dev);

	chinfo.src = 10000;
	chinfo.dst = 10000;
	pingpong_dev->ept1 = rpmsg_create_ept(rpdev, rpmsg_pingpong_test_cb, pingpong_dev, chinfo);

	if (!pingpong_dev->ept1) {
		dev_err(&rpdev->dev, "failed to create endpoint:%d\n", chinfo.dst);
	}

	chinfo.src = 10001;
	chinfo.dst = 10001;
	pingpong_dev->ept2 = rpmsg_create_ept(rpdev, rpmsg_pingpong_test_cb, pingpong_dev, chinfo);

	if (!pingpong_dev->ept2) {
		dev_err(&rpdev->dev, "failed to create endpoint:%d\n", chinfo.dst);
	}

	rpmsg_pingpong = 0;
	err = rpmsg_sendto(pingpong_dev->ept1, (void *)(&rpmsg_pingpong), 4, rpdev->dst);
	if (err) {
		dev_err(&rpdev->dev, "rpmsg_send failed: %d\n", err);
		return err;
	}
#if 0
	/*
	 * send a message to our remote processor, and tell remote
	 * processor about this channel
	 */
	err = rpmsg_send(rpdev->ept, MSG, strlen(MSG));
	if (err) {
		dev_err(&rpdev->dev, "rpmsg_send failed: %d\n", err);
		return err;
	}

	rpmsg_pingpong = 0;
	rx_count = 0;
	err = rpmsg_sendto(rpdev->ept, (void *)(&rpmsg_pingpong), 4, rpdev->dst);
	if (err) {
		dev_err(&rpdev->dev, "rpmsg_send failed: %d\n", err);
		return err;
	}
#endif

	return 0;
}

static void rpmsg_pingpong_remove(struct rpmsg_device *rpdev)
{
	dev_info(&rpdev->dev, "rpmsg pingpong driver is removed\n");
}

static struct rpmsg_device_id rpmsg_driver_pingpong_id_table[] = {
	{ .name	= "rpmsg-openamp-demo-channel" },
	{ .name	= "rpmsg-openamp-demo-channel2" },
	{ },
};
MODULE_DEVICE_TABLE(rpmsg, rpmsg_driver_pingpong_id_table);

static struct rpmsg_driver rpmsg_pingpong_driver = {
	.drv.name	= KBUILD_MODNAME,
	.drv.owner	= THIS_MODULE,
	.id_table	= rpmsg_driver_pingpong_id_table,
	.probe		= rpmsg_pingpong_probe,
	.callback	= rpmsg_pingpong_cb,
	.remove		= rpmsg_pingpong_remove,
};

static int __init init(void)
{
	return register_rpmsg_driver(&rpmsg_pingpong_driver);
}

static void __exit fini(void)
{
	unregister_rpmsg_driver(&rpmsg_pingpong_driver);
}
module_init(init);
module_exit(fini);

MODULE_AUTHOR("SSTAR");
MODULE_DESCRIPTION("SSTAR virtio remote processor messaging pingpong driver");
MODULE_LICENSE("GPL");
